using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// VbecsVistALinkBaseForm is to be used by forms that need to call VistALink during their initialization.
	/// Derived forms should override the OnVistALinkFormLoad method and code calling VistALink should be 
	/// implemented within this method.
	/// </summary>
	public class VbecsVistALinkBaseForm : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Variable determining whether the form has been initialized or not.
		/// </summary>
		private bool _initialized;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public VbecsVistALinkBaseForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// Variable should default to false
			_initialized = false;
		}

		#endregion

		#region Events

		/// <summary>
		/// Visible Changed Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnVisibleChanged(EventArgs e)
		{
			base.OnVisibleChanged (e);
			if (!_initialized) 
			{
				_initialized = true;
				OnVistALinkFormLoad(e);
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// This method should be overridden in derived forms and code calling VistALink should reside here.
		/// </summary>
		protected virtual void OnVistALinkFormLoad( EventArgs e )
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.Size = new System.Drawing.Size(300,300);
			this.Text = "VbecsVistALinkBaseForm";
		}
		#endregion
	}
}
